/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.RequestSelectionInstallBean;
import com.ibm.hwmca.base.updates.RetrieveInternalCodeChgsBean;
import com.ibm.hwmca.base.updates.RetrieveInternalCodeConstants;
import com.ibm.hwmca.base.updates.StartChgEndChgBean;
import com.ibm.hwmca.base.updates.UpdateUtilities;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaServicesBusyInterface;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtil;
import com.ibm.hwmca.fw.mediasvc.MediaServicesUtilException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.task.HwmcaPanelTasklet;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.ProgressUpdateEvent;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.updates.UpdateManager;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import com.ibm.hwmca.xfw.updates.Updater;
import com.ibm.hwmca.xfw.updates.UpdaterEvent;
import com.ibm.hwmca.xfw.updates.UpdaterListener;
import com.ibm.hwmca.xfw.updates.UpdatesOwner;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RetrieveInternalCodeTasklet
extends HwmcaPanelTasklet
implements RetrieveInternalCodeConstants,
UpdatesErrorIds,
CommonMsgInterface,
UpdaterListener,
ProgressEndedListener,
MediaServicesBusyInterface {
    private static final String TRACE_MASKT = "XMCLRITT";
    private static final String TRACE_MASKF = "XMCLRITF";
    private static final String TRACE_MASKD = "XMCLRITD";
    private UpdateManager theUpdateManager;
    private PanelHandler currentPanel;
    private ManagedObject[] targetObjects;
    private List targetObjectNames;
    private boolean postRequestOnDispose = false;
    private int savedImportExportOperationType;
    private MediaServicesUtil savedMediaServUtil = null;
    private static boolean progressDismissed;
    private static final String PROGRESS_PANEL_ID = "RetrieveInternalProgID";
    private ProgressReportListenerImpl reportListener = null;
    private PanelTaskletProgressListener savedProgListener = null;
    private static final FrameworkClassLogInfo classLogInfo;
    private boolean isBusyDesiredForMediaOperations = true;
    LocalizableText busyMessage = null;
    private PanelHandler RetrieveInternalCodeChgsPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "-> RetrieveInternalCodeTasklet.RetrieveInternalCodeChgsPanelHandler.service()");
            if (request.isDisposed() || request.isCanceled()) {
                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [RetrieveInternalCodeChgsPanelHandler.service()] Terminate task because the main panel is being disposed.");
                response.terminate();
            } else {
                String source = (String)request.getData("source");
                if (null != source && source.equalsIgnoreCase("server")) {
                    Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [RetrieveInternalCodeChgsPanelHandler.service()] Handling server initiated request to continue processing.");
                    RetrieveInternalCodeTasklet.this.confirmImportExport(response, null);
                } else {
                    TaskActionEvent event = (TaskActionEvent)request.getData("event");
                    String command = event.getActionCommand();
                    if (command.equalsIgnoreCase("ObjectListButton")) {
                        RetrieveInternalCodeTasklet.this.postRequestOnDispose = false;
                        RequestSelectionInstallBean bean = new RequestSelectionInstallBean();
                        bean.setPanelData(RetrieveInternalCodeTasklet.this.targetObjectNames);
                        RetrieveInternalCodeTasklet.this.currentPanel = RetrieveInternalCodeTasklet.this.RequestSelectionInstallPanelHandler;
                        response.openModalChild("com.ibm.hwmca.base.updates.res.RetrieveInternalCodeRes", "RequestSelectionInstallPanel", bean);
                    } else {
                        String radioButton = (String)request.getData("radioButton");
                        Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [RetrieveInternalCodeChgsPanelHandler.service()] The selected radio button is '" + radioButton + "'");
                        if (radioButton.equalsIgnoreCase("RetrieveFromDiskChoice") || radioButton.equalsIgnoreCase("RetrieveFromDVDChoice") || radioButton.equalsIgnoreCase("RetrieveToDiskChoice") || radioButton.equalsIgnoreCase("RetrieveToDVDChoice")) {
                            String msgTitleKey;
                            String msgTextKey;
                            boolean mountReadWrite;
                            int mediaType;
                            if (radioButton.equalsIgnoreCase("RetrieveFromDiskChoice")) {
                                RetrieveInternalCodeTasklet.this.savedImportExportOperationType = 1;
                                mediaType = 1;
                                mountReadWrite = false;
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes from diskette' choice.");
                            } else if (radioButton.equalsIgnoreCase("RetrieveFromDVDChoice")) {
                                RetrieveInternalCodeTasklet.this.savedImportExportOperationType = 2;
                                mediaType = 6;
                                mountReadWrite = false;
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes from DVD' choice.");
                            } else if (radioButton.equalsIgnoreCase("RetrieveToDiskChoice")) {
                                RetrieveInternalCodeTasklet.this.savedImportExportOperationType = 4;
                                mediaType = 1;
                                mountReadWrite = true;
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes to diskette' choice.");
                            } else {
                                RetrieveInternalCodeTasklet.this.savedImportExportOperationType = 5;
                                mediaType = 6;
                                mountReadWrite = true;
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, "Handle 'Retrieve code changes to DVD' choice.");
                            }
                            if (mediaType == 1) {
                                msgTextKey = "MCL0016";
                                msgTitleKey = "MCL8016";
                            } else {
                                msgTextKey = "MCL0017";
                                msgTitleKey = "MCL8017";
                            }
                            boolean continueTask = RetrieveInternalCodeTasklet.this.isUserContinuingAfterMsg(msgTitleKey, msgTextKey, null, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                            if (continueTask) {
                                MediaDevice mediaDevice = RetrieveInternalCodeTasklet.this.getMediaDevice(mediaType, mountReadWrite);
                                if (null == mediaDevice) {
                                    response.noAction();
                                } else {
                                    switch (RetrieveInternalCodeTasklet.this.savedImportExportOperationType) {
                                        case 1: 
                                        case 2: {
                                            RetrieveInternalCodeTasklet.this.releaseMediaDeviceLock();
                                            RetrieveInternalCodeTasklet.this.confirmImportExport(response, null);
                                            break;
                                        }
                                        default: {
                                            try {
                                                File mountPoint = mediaDevice.getMountPoint();
                                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [RetrieveInternalCodeChgsPanelHandler.service()] mount point path: '" + mountPoint.getPath() + "'");
                                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [RetrieveInternalCodeChgsPanelHandler.service()] composite name: '" + mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt'");
                                                File inputFile = new File(mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt");
                                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [RetrieveInternalCodeChgsPanelHandler.service()] the media persisted file: '" + inputFile.getPath() + "'");
                                                ArrayList<String> defaultECNumbers = new ArrayList<String>();
                                                try {
                                                    String line;
                                                    BufferedReader in = new BufferedReader(new FileReader(inputFile));
                                                    while (null != (line = in.readLine())) {
                                                        defaultECNumbers.add(line);
                                                    }
                                                    in.close();
                                                }
                                                catch (IOException ioe) {
                                                    Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [RetrieveInternalCodeChgsPanelHandler.service()] caught IOException: " + ioe);
                                                }
                                                List suggestedULs = null;
                                                if (!defaultECNumbers.isEmpty()) {
                                                    UpdateUtilities updateUtil = new UpdateUtilities();
                                                    suggestedULs = updateUtil.getSuggestedUpdateLevelsForMedia(mountPoint, mediaType, defaultECNumbers);
                                                }
                                                RetrieveInternalCodeTasklet.this.releaseMediaDeviceLock();
                                                StartChgEndChgBean bean = new StartChgEndChgBean();
                                                bean.initializeWithServerData(suggestedULs);
                                                RetrieveInternalCodeTasklet.this.currentPanel = RetrieveInternalCodeTasklet.this.StartChgEndChgPanelHandler;
                                                response.openModalChild("com.ibm.hwmca.base.updates.res.RetrieveInternalCodeRes", "StartChgEndChgPanel", bean);
                                                break;
                                            }
                                            catch (MediaDeviceException mde) {
                                                System.out.println(" XMCL -------> MediaDeviceException: " + mde);
                                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, " [RetrieveInternalCodeChgsPanelHandler.service()] caught exception: " + mde);
                                                mde.printStackTrace();
                                                RetrieveInternalCodeTasklet.this.releaseMediaDeviceLock();
                                                RetrieveInternalCodeTasklet.this.showMessage("MCL8116", "MCL0018");
                                                response.noAction();
                                            }
                                        }
                                    }
                                }
                            } else {
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [RetrieveInternalCodeChgsPanelHandler.service()] User must have canceled the 'insert media' panel.");
                                response.noAction();
                            }
                        } else if (radioButton.equalsIgnoreCase("RetrieveFromIBMChoice")) {
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [RetrieveInternalCodeChgsPanelHandler.service()] Handle 'Retrieve code changes from IBM support' choice.");
                            RetrieveInternalCodeTasklet.this.savedImportExportOperationType = 3;
                            RetrieveInternalCodeTasklet.this.confirmImportExport(response, null);
                        } else {
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [RetrieveInternalCodeChgsPanelHandler.service()] Ignore unknown radio button '" + radioButton + "'");
                            response.noAction();
                        }
                    }
                }
            }
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "<- RetrieveInternalCodeTasklet.RetrieveInternalCodeChgsPanelHandler.service()");
        }
    };
    private PanelHandler RequestSelectionInstallPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "-> RetrieveInternalCodeTasklet.RequestSelectionInstallPanelHandler.service()");
            RetrieveInternalCodeTasklet.this.currentPanel = RetrieveInternalCodeTasklet.this.RetrieveInternalCodeChgsPanelHandler;
            response.dispose();
            if (RetrieveInternalCodeTasklet.this.postRequestOnDispose) {
                RetrieveInternalCodeTasklet.this.postRedisplayMessageBoxRequest("RetrieveInternalCodeChgsPanel");
            }
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "<- RetrieveInternalCodeTasklet.RequestSelectionInstallPanelHandler.service()");
        }
    };
    private PanelHandler StartChgEndChgPanelHandler = new PanelHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "-> RetrieveInternalCodeTasklet.StartChgEndChgPanelHandler");
            if (request.isDisposed() || request.isCanceled()) {
                RetrieveInternalCodeTasklet.this.currentPanel = RetrieveInternalCodeTasklet.this.RetrieveInternalCodeChgsPanelHandler;
                response.dispose();
            } else {
                List urList = (List)request.getData("userData");
                if (!urList.isEmpty()) {
                    int mediaType = RetrieveInternalCodeTasklet.this.savedImportExportOperationType == 4 ? 1 : 6;
                    MediaDevice mediaDevice = RetrieveInternalCodeTasklet.this.getMediaDevice(mediaType, true);
                    if (null == mediaDevice) {
                        Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                    } else {
                        try {
                            File mountPoint = mediaDevice.getMountPoint();
                            File mediaDir = new File(mountPoint.getPath() + File.separator + "taskinfo");
                            if (!mediaDir.exists()) {
                                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [StartChgEndChgPanelHandler.service()] Creating directory on media.");
                                mediaDir.mkdir();
                            }
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKD, " [StartChgEndChgPanelHandler.service()] Ready to write file on media.");
                            File outputFile = new File(mountPoint.getPath() + File.separator + "taskinfo" + File.separator + "persist.txt");
                            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile));
                            Iterator iterator = urList.iterator();
                            while (iterator.hasNext()) {
                                out.write(((UpdateRange)iterator.next()).getUpdateableComponentECNumber());
                                out.newLine();
                            }
                            out.close();
                        }
                        catch (MediaDeviceException mde) {
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] caught exception: " + mde);
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                            mde.printStackTrace();
                        }
                        catch (IOException ioe) {
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] caught IOException: " + ioe);
                            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, " [StartChgEndChgPanelHandler.service()] Unable to write out EC numbers to media file.");
                        }
                        finally {
                            RetrieveInternalCodeTasklet.this.releaseMediaDeviceLock();
                        }
                    }
                    RetrieveInternalCodeTasklet.this.confirmImportExport(response, urList);
                } else {
                    Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKF, " [StartChgEndChgPanelHandler.service()] Ignoring request since no valid EC number and level combinations specified.");
                    response.noAction();
                }
            }
            Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "<- RetrieveInternalCodeTasklet.StartChgEndChgPanelHandler");
        }
    };

    public RetrieveInternalCodeTasklet() {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet constructor");
        this.setExplicitTerminate(true);
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet constructor");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.service()");
        try {
            if (request.isInitialRequest()) {
                ObjectId[] targetIds = this.presentationTaskParms.getTargetIds();
                this.targetObjects = (ManagedObject[])this.getObjectsForIds(targetIds);
                int numObjects = this.targetObjects.length;
                this.targetObjectNames = new ArrayList(numObjects);
                for (int i = 0; i < numObjects; ++i) {
                    ManagedObject targetObject = this.targetObjects[i];
                    this.targetObjectNames.add(targetObject.getUIInfo().getName());
                    Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.service()]  Targeted managed object #" + i + ":" + this.targetObjectNames.get(i));
                }
                this.theUpdateManager = UpdateManager.getUpdateManager();
                this.currentPanel = this.RetrieveInternalCodeChgsPanelHandler;
                response.replace("com.ibm.hwmca.base.updates.res.RetrieveInternalCodeRes", "RetrieveInternalCodeChgsPanel", new RetrieveInternalCodeChgsBean());
            } else {
                String restart = (String)request.getData("restart");
                if (null != restart) {
                    Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.service()]  Restarting main panel.");
                    this.currentPanel = this.RetrieveInternalCodeChgsPanelHandler;
                    response.replace("com.ibm.hwmca.base.updates.res.RetrieveInternalCodeRes", "RetrieveInternalCodeChgsPanel", new RetrieveInternalCodeChgsBean());
                } else {
                    this.currentPanel.service(request, response);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, " [RetrieveInternalCodeTasklet.service()] caught exception: " + e);
            e.printStackTrace();
            new FrameworkLog(classLogInfo, -3837, e).log();
            Trace.trace(TRACE_MASKT, " [RetrieveInternalCodeTasklet.service()] Terminate task due to unrecoverable error.");
            response.terminate();
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.service()");
    }

    private void confirmImportExport(PanelTaskletResponse response, List specificList) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.confirmImportExport");
        boolean isExportCase = false;
        String confirmationMsgKey = null;
        switch (this.savedImportExportOperationType) {
            case 4: 
            case 5: {
                isExportCase = true;
                confirmationMsgKey = "MCL0047";
                break;
            }
            case 1: 
            case 2: {
                confirmationMsgKey = "MCL0045";
                break;
            }
            default: {
                confirmationMsgKey = "MCL0046";
            }
        }
        LocalizableText retrieveButtonText = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexport.button");
        LocalizableText objectListButtonText = new LocalizableText(BaseTextBundle.getBundleName(), "updates.objectlist.button");
        LocalizableText[] buttons = isExportCase ? new LocalizableText[]{retrieveButtonText, CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON} : new LocalizableText[]{retrieveButtonText, objectListButtonText, CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON};
        LocalizableText buttonPressed = this.showMessage("MCL8001", confirmationMsgKey, null, buttons);
        if (null != buttonPressed) {
            Trace.trace(TRACE_MASKD, " [confirmImportExport] Button pressed on message box was '" + buttonPressed + "'");
            if (buttonPressed.toString().equals(retrieveButtonText.toString())) {
                this.startOperationThread(response, specificList);
            } else if (buttonPressed.toString().equals(objectListButtonText.toString())) {
                this.postRequestOnDispose = true;
                RequestSelectionInstallBean bean = new RequestSelectionInstallBean();
                bean.setPanelData(this.targetObjectNames);
                this.currentPanel = this.RequestSelectionInstallPanelHandler;
                response.openModalChild("com.ibm.hwmca.base.updates.res.RetrieveInternalCodeRes", "RequestSelectionInstallPanel", bean);
            } else {
                response.noAction();
            }
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.confirmImportExport");
    }

    private void startOperationThread(PanelTaskletResponse response, List specList) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.startOperationThread()");
        final List specificList = specList;
        Runnable progRun = new Runnable(){

            public void run() {
                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "-> RetrieveInternalCodeTasklet.startOperationThread.run()");
                RetrieveInternalCodeTasklet.this.performImportExport(specificList);
                Trace.trace(RetrieveInternalCodeTasklet.TRACE_MASKT, "<- RetrieveInternalCodeTasklet.startOperationThread().run()");
            }
        };
        new Thread(progRun, "RetrieveInternalCodeTasklet").start();
        response.dispose();
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.startOperationThread()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImportExport(List specificList) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.performImportExport()");
        int mediaType = 0;
        boolean mountReadWrite = false;
        boolean isSupportImport = false;
        switch (this.savedImportExportOperationType) {
            case 1: {
                mediaType = 1;
                break;
            }
            case 2: {
                mediaType = 6;
                break;
            }
            case 4: {
                mediaType = 1;
                mountReadWrite = true;
                break;
            }
            case 5: {
                mediaType = 6;
                mountReadWrite = true;
                break;
            }
            default: {
                isSupportImport = true;
            }
        }
        boolean continueTask = true;
        File mountPoint = null;
        if (!isSupportImport) {
            MediaDevice mediaDevice = this.getMediaDevice(mediaType, mountReadWrite);
            if (null != mediaDevice) {
                try {
                    mountPoint = mediaDevice.getMountPoint();
                }
                catch (MediaDeviceException mde) {
                    Trace.trace(TRACE_MASKT, " [performImportExport()] caught exception: " + mde);
                    continueTask = false;
                    this.showMessage("MCL8116", "MCL0018");
                }
            } else {
                continueTask = false;
            }
        }
        if (continueTask) {
            if (this.savedImportExportOperationType == 4 || this.savedImportExportOperationType == 5) {
                int completionStatus;
                LocalizableText completionMessage;
                long duration = 0L;
                PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(this);
                ProgressStartEvent start = new ProgressStartEvent(new LocalizableText(this.getTask().getUIInfo().getTitle()), new ProgressData[]{new ProgressData()}, duration, new LocalizableText(BaseTextBundle.getBundleName(), "updates.exportstart.text"), PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
                progListener.startProgress(start);
                UpdateUtilities updateUtil = new UpdateUtilities();
                boolean gotException = false;
                try {
                    updateUtil.exportRemoteUnstagedCollectionsToMedia(progListener, mountPoint, mediaType, specificList, PROGRESS_PANEL_ID);
                }
                catch (HException he) {
                    Trace.trace(TRACE_MASKT, " [performImportExport()] caught exception: " + he);
                    gotException = true;
                }
                if (!gotException) {
                    completionMessage = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexportdone.text");
                    completionStatus = 1;
                } else {
                    completionMessage = new LocalizableText(BaseTextBundle.getBundleName(), "updates.importexportfail.text");
                    completionStatus = 3;
                }
                ProgressData progData = new ProgressData(completionMessage);
                progData.setCompletionStatus(completionStatus);
                ProgressUpdateEvent progUpdateEvent = new ProgressUpdateEvent(progData, PROGRESS_PANEL_ID);
                this.savedProgListener.updateProgress(progUpdateEvent);
                Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.performImportExport()] End progress panel elapsed time.");
                progListener.endProgress(new ProgressEndEvent(PROGRESS_PANEL_ID));
            } else {
                int count = this.targetObjects.length;
                UpdatesOwner[] upOwner = new UpdatesOwner[count];
                Updater[] updater = new Updater[count];
                long duration = 0L;
                Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.performImportExport()] - about to perform the requested operation");
                ProgressData[] progData = new ProgressData[count];
                ObjectId[] ids = new ObjectId[count];
                Trace.trace(TRACE_MASKD, "   RetrieveInternalCodeTasklet.performImportExport() number of managed objects in the array: " + count);
                for (int i = 0; i < count; ++i) {
                    ids[i] = this.targetObjects[i].getObjectId();
                    upOwner[i] = this.theUpdateManager.getOwnerForManagedObject(this.targetObjects[i]);
                    if (null == upOwner[i]) {
                        updater[i] = null;
                    } else {
                        updater[i] = upOwner[i].getUpdaterInstance();
                        updater[i].addUpdaterListener(this);
                        updater[i].setAttachment(ids[i]);
                    }
                    progData[i] = new ProgressData(new LocalizableText((String)this.targetObjectNames.get(i)), ids[i], duration);
                }
                PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(this);
                ProgressStartEvent start = new ProgressStartEvent(new LocalizableText(this.getTask().getUIInfo().getTitle()), progData, duration, new LocalizableText(BaseTextBundle.getBundleName(), "updates.retrvint.progress.initial"), PROGRESS_PANEL_ID, (ProgressCancelListener)null, (ProgressEndedListener)this);
                progListener.startProgress(start);
                this.reportListener = new ProgressReportListenerImpl(PROGRESS_PANEL_ID, ids, progListener);
                Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.performImportExport()] Starting operation for each target object.");
                RetrieveInternalCodeTasklet retrieveInternalCodeTasklet = this;
                synchronized (retrieveInternalCodeTasklet) {
                    progressDismissed = false;
                    for (int i = 0; i < count; ++i) {
                        if (null != updater[i]) {
                            if (this.savedImportExportOperationType == 1 || this.savedImportExportOperationType == 2) {
                                Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.performImportExport()] call importAllUnstagedUpdatesFromMedia for updater #" + i);
                                Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.performImportExport()]         passing in mountPoint: " + mountPoint);
                                Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.performImportExport()]         passing in mediaType: " + mediaType);
                                updater[i].importAllUnstagedUpdatesFromMedia(mountPoint, mediaType);
                                continue;
                            }
                            if (this.savedImportExportOperationType != 3) continue;
                            Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.performImportExport()] call importAllRemoteUnstagedUpdates for updater #" + i);
                            updater[i].importAllRemoteUnstagedUpdates(false);
                            continue;
                        }
                        CompletionReport rpt = new CompletionReport(ids[i]);
                        rpt.setCompletionCode(CompletionReportCode.FAIL);
                        rpt.setData(new LocalizableText(BaseTextBundle.getBundleName(), "updates.null.updatesowner"));
                        this.reportListener.completeReport(rpt);
                    }
                    while (!progressDismissed) {
                        try {
                            Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.performImportExport()] entering wait()");
                            this.wait();
                            Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.performImportExport()] leaving wait()");
                        }
                        catch (InterruptedException exc) {
                            Trace.trace(TRACE_MASKD, " [ChangeInternalCodeTasklet.startOperation()]   wait() loop     We got interrupted, so simply loop around.");
                        }
                    }
                }
            }
            Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.performImportExport()] progress window has been dismissed");
        }
        this.releaseMediaDeviceLock();
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData("restart", "restart");
        try {
            this.postRequest(null, request);
        }
        catch (TaskletException te) {
            this.logException(te);
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.performImportExport()");
    }

    private MediaServicesUtil getMediaServicesUtil() {
        if (null == this.savedMediaServUtil) {
            this.savedMediaServUtil = new MediaServicesUtil(this);
        }
        return this.savedMediaServUtil;
    }

    private MediaDevice getMediaDevice(int mediaType, boolean mountReadWrite) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.getMediaDevice()");
        MediaDevice mediaDevice = null;
        try {
            mediaDevice = this.getMediaServicesUtil().prepareMedia(mediaType, new LocalizableText(BaseTextBundle.getBundleName(), "updates.retrieve.mediaservices.name"), mountReadWrite, null);
        }
        catch (MediaServicesUtilException msue) {
            Trace.trace(TRACE_MASKT, " [getMediaDevice()] caught exception: " + msue);
            Trace.trace(TRACE_MASKT, " [getMediaDevice()] The exception type is: " + Integer.toString(msue.getErrorType()));
            if (msue.getErrorType() != 11) {
                this.showMessage("MCL8116", "MCL0018");
            }
            this.releaseMediaDeviceLock();
        }
        if (null == mediaDevice) {
            Trace.trace(TRACE_MASKD, " [getMediaDevice()] returning a NULL media device.");
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.getMediaDevice()");
        return mediaDevice;
    }

    private void releaseMediaDeviceLock() {
        if (null != this.savedMediaServUtil) {
            try {
                Trace.trace(TRACE_MASKD, " [RetrieveInternalCodeTasklet.releaseMediaDeviceLock()]Releasing media device lock.");
                this.savedMediaServUtil.releaseMedia();
            }
            catch (MediaServicesUtilException mediaServicesUtilException) {
                // empty catch block
            }
        }
    }

    private void postRedisplayMessageBoxRequest(String targetBean) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.postRedisplayMessageBoxRequest()");
        PanelTaskletRequest newRequest = new PanelTaskletRequest();
        newRequest.setData("source", "server");
        try {
            this.postRequest(targetBean, newRequest);
        }
        catch (TaskletException te) {
            Trace.trace(TRACE_MASKD, " [postRedisplayMessageBoxRequest()] caught exception: " + te);
            te.printStackTrace();
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.postRedisplayMessageBoxRequest()");
    }

    private boolean isUserContinuingAfterMsg(String titleKey, String messageKey, String[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.isUserContinuingAfterMsg()");
        boolean firstButtonFlag = false;
        LocalizableText buttonPressed = this.showMessage(titleKey, messageKey, substitutions, options);
        if (null != buttonPressed) {
            Trace.trace(TRACE_MASKD, " [isUserContinuingAfterMsg()] Button pressed on message box was '" + buttonPressed + "'");
        }
        if (null != buttonPressed) {
            if (null != options) {
                if (buttonPressed.toString().equals(options[0].toString())) {
                    firstButtonFlag = true;
                }
            } else if (buttonPressed.toString().equals(CommonMsgInterface.OK_BUTTON.toString()) || buttonPressed.toString().equals(CommonMsgInterface.YES_BUTTON.toString())) {
                firstButtonFlag = true;
            }
        }
        Trace.trace(TRACE_MASKF, " [isUserContinuingAfterMsg()] returning '" + firstButtonFlag + "'");
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.isUserContinuingAfterMsg()");
        return firstButtonFlag;
    }

    private void showMessage(String titleKey, String messageKey) {
        this.showMessage(titleKey, messageKey, null, null);
    }

    private LocalizableText showMessage(String titleKey, String messageKey, String[] substitutions, LocalizableText[] options) {
        Trace.trace(TRACE_MASKT, "<> RetrieveInternalCodeTasklet.showMessage()");
        LocalizableText buttonPressed = null;
        try {
            BaseMessageText message = null == substitutions ? new BaseMessageText(messageKey) : new BaseMessageText(messageKey, substitutions);
            buttonPressed = this.showMessageBox(true, new BaseMessageTitle(titleKey), message, null, options);
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, " [showMessage()] Exception working with message box!");
        }
        return buttonPressed;
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.logException()");
        Trace.trace(TRACE_MASKT, "   processing exception: " + throwable);
        new FrameworkLog(classLogInfo, -3838, throwable).log();
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.logException()");
    }

    public void operationCompleted(UpdaterEvent e) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.operationCompleted()");
        Updater up = (Updater)e.getSource();
        ObjectId oid = (ObjectId)up.getAttachment();
        CompletionReport rpt = new CompletionReport(oid);
        int status = e.getCompletionStatus();
        LocalizableText msg = e.getMessage();
        if (2 == status) {
            rpt.setCompletionCode(CompletionReportCode.FAIL);
            LocalizableText msgDetail = e.getDetailsMessage();
            if (null != msgDetail) {
                msg = msgDetail;
            }
            rpt.setData(msg);
        } else {
            rpt.setCompletionCode(CompletionReportCode.SUCCESS);
            rpt.setText(msg);
        }
        if (null == msg) {
            Trace.trace(TRACE_MASKD, " [operationCompleted()] The completion message is null.");
        } else {
            Trace.trace(TRACE_MASKD, " [operationCompleted()] The completion message is '" + msg + "'.");
        }
        this.reportListener.completeReport(rpt);
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.operationCompleted()");
    }

    public void operationProgressing(UpdaterEvent e) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.operationProgressing()");
        Updater up = (Updater)e.getSource();
        ObjectId oid = (ObjectId)up.getAttachment();
        this.reportListener.intermediateReport(new StepReport(oid, e.getMessage()));
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.operationProgressing()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> RetrieveInternalCodeTasklet.progressEnded()");
        RetrieveInternalCodeTasklet retrieveInternalCodeTasklet = this;
        synchronized (retrieveInternalCodeTasklet) {
            progressDismissed = true;
            Trace.trace(TRACE_MASKF, " [RetrieveInternalCodeTasklet.progressEnded()] entering notifyAll()");
            this.notifyAll();
            Trace.trace(TRACE_MASKF, " [progressEnded()] leaving notifyAll()");
        }
        Trace.trace(TRACE_MASKT, "<- RetrieveInternalCodeTasklet.progressEnded()");
    }

    public boolean isBusyDesired() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.isBusyDesired() - " + this.isBusyDesiredForMediaOperations);
        return this.isBusyDesiredForMediaOperations;
    }

    public LocalizableText getBusyMessage() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.getBusyMessage() -  returning [" + this.busyMessage + "]");
        return this.busyMessage;
    }

    public PanelTasklet getPanelTasklet() {
        Trace.trace(TRACE_MASKT, "<> ChangeConsoleIntCodeTasklet.getPanelTasklet() -  returning ourself");
        return this;
    }

    static {
        classLogInfo = new FrameworkClassLogInfo(2, "RetrieveInternalCodeTasklet");
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

